<?php include( 'assets/inc/header.php' ); ?>

            <div class="container">
                <div class="row">
                    
                    
                    <?php include( 'assets/inc/profile.php' ); ?>
                    
                    <div class="col-lg-10 px-md-5 text-center">
                        <img style="max-width: 320px" src="assets/img/graphic-faq.png">
                        <h2 class="font-weight-bold text pt-4 mb-5">Frequently Asked Questions</h2>
                        <div id="accordion" class="accordion">
                            <div class="card mb-0 text-left">
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapseOne">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">When should I refinance?</span>
                                    </a>
                                </div>
                                <div id="collapseOne" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">It's generally a good time to refinance when mortgage rates are 2% lower than the current rate on your loan. It may be a viable option even if the interest rate difference is only 1% or less. Any reduction can trim your monthly mortgage payments. Example: Your payment, excluding taxes and insurance, would be about $770 on a $100,000 loan at 8.5%; if the rate were lowered to 7.5%, your payment would then be $700, now you're saving $70 per month. Your savings depends on your income, budget, loan amount, and interest rate changes. Your trusted lender can help you calculate your options.</p>
                                </div>
                                
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapseTwo">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">What are points?</span>
                                    </a>
                                </div>
                                <div id="collapseTwo" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">A point is a percentage of the loan amount, or 1-point = 1% of the loan, so one point on a $100,000 loan is $1,000. Points are costs that need to be paid to a lender to get mortgage financing under specified terms. Discount points are fees used to lower the interest rate on a mortgage loan by paying some of this interest up-front. Lenders may refer to costs in terms of basic points in hundredths of a percent, 100 basis points = 1 point, or 1% of the loan amount.</p>
                                </div>
                                
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapseThree">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">Should I pay points to lower my interest rate?</span>
                                    </a>
                                </div>
                                <div id="collapseThree" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">Yes, if you plan to stay in the property for a least a few years. Paying discount points to lower the loan's interest rate is a good way to lower your required monthly loan payment, and possibly increase the loan amount that you can afford to borrow. However, if you plan to stay in the property for only a year or two, your monthly savings may not be enough to recoup the cost of the discount points that you paid up-front.</p>
                                </div>
                                
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapseFour">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">What is an APR?</span>
                                    </a>
                                </div>
                                <div id="collapseFour" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">The annual percentage rate (APR) is an interest rate reflecting the cost of a mortgage as a yearly rate. This rate is likely to be higher than the stated note rate or advertised rate on the mortgage, because it takes into account points and other credit costs. The APR allows homebuyers to compare different types of mortgages based on the annual cost for each loan. The APR is designed to measure the "true cost of a loan." It creates a level playing field for lenders. It prevents lenders from advertising a low rate and hiding fees.</p>
                                    <p class="px-3">The APR does not affect your monthly payments. Your monthly payments are strictly a function of the interest rate and the length of the loan.</p>
                                    <p class="px-3">Because APR calculations are effected by the various different fees charged by lenders, a loan with a lower APR is not necessarily a better rate. The best way to compare loans is to ask lenders to provide you with a good-faith estimate of their costs on the same type of program (e.g. 30-year fixed) at the same interest rate. You can then delete the fees that are independent of the loan such as homeowners insurance, title fees, escrow fees, attorney fees, etc. Now add up all the loan fees. The lender that has lower loan fees has a cheaper loan than the lender with higher loan fees.</p>
                                    <p class="px-3">The following fees are generally included in the APR:</p>
                                    <p class="ml-4 pt-0 px-3">
                                    <ul>
                                        <li>Points - both discount points and origination points</li>
                                        <li>Pre-paid interest. The interest paid from the date the loan closes to the end of the month.</li>
                                        <li>Loan-processing fee</li>
                                        <li>Underwriting fee</li>
                                        <li>Document-preparation fee</li>
                                        <li>Private mortgage-insurance</li>
                                        <li>Escrow fee</li>
                                    </ul>
                                    </p>
                                    <p class="px-3">The following fees are normally not included in the APR:</p>
                                    <p class="ml-4 pt-0 px-3">
                                    <ul>
                                        <li>Title or abstract fee</li>
                                        <li>Borrower Attorney fee</li>
                                        <li>Home-inspection fees</li>
                                        <li>Recording fee</li>
                                        <li>Transfer taxes</li>
                                        <li>Credit report</li>
                                        <li>Appraisal fee</li>
                                    </ul>
                                    </p>
                                </div>
                                
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapseFive">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">What does it mean to lock the interest rate?</span>
                                    </a>
                                </div>
                                <div id="collapseFive" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">Mortgage rates can change from the day you apply for a loan to the day you close the transaction. If interest rates rise sharply during the application process it can increase the borrower’s mortgage payment unexpectedly. Therefore, a lender can allow the borrower to "lock-in" the loan’s interest rate guaranteeing that rate for a specified time period, often 30-60 days, sometimes for a fee.</p>
                                </div>
                                
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapseSix">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">What documents do I need to prepare for my loan application?</span>
                                    </a>
                                </div>
                                <div id="collapseSix" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">Below is a list of documents that are required when you apply for a mortgage. However, every situation is unique and you may be required to provide additional documentation. So, if you are asked for more information, be cooperative and provide the information requested as soon as possible. It will help speed up the application process.</p>
                                
                                    <p class="px-3 font-weight-bold">Your Property</p>
                                    <p class="ml-4 pt-0 px-3">
                                    <ul>
                                        <li>Copy of signed sales contract including all riders</li>
                                        <li>Verification of the deposit you placed on the home</li>
                                        <li>Names, addresses and telephone numbers of all realtors, builders, insurance agents and attorneys involved</li>
                                        <li>Copy of Listing Sheet and legal description if available (if the property is a condominium please provide condominium declaration, by-laws and most recent budget)</li>
                                    </ul>
                                    </p>
                                    
                                    <p class="px-3 font-weight-bold">Your Income</p>
                                    <p class="ml-4 pt-0 px-3">
                                    <ul>
                                        <li>Copies of your pay-stubs for the most recent 30-day period and year-to-date</li>
                                        <li>Copies of your W-2 forms for the past two years</li>
                                        <li>Names and addresses of all employers for the last two years</li>
                                        <li>Letter explaining any gaps in employment in the past 2 years</li>
                                        <li>Work visa or green card (copy front & back)</li>
                                    </ul>
                                    </p>
                                    
                                    <p class="px-3">If <span class="font-weight-bold">self-employed</span> or receive <span class="font-weight-bold">commission</span> or <span class="font-weight-bold">bonus, interest/dividends,</span> or <span class="font-weight-bold">rental income:</span></p>
                                    <p class="ml-4 pt-0 px-3">
                                    <ul>
                                        <li>Provide full tax returns for the last two years PLUS year-to-date Profit and Loss statement (please provide complete tax return including attached schedules and statements. If you have filed an extension, please supply a copy of the extension.)</li>
                                        <li>K-1's for all partnerships and S-Corporations for the last two years (please double-check your return. Most K-1's are not attached to the 1040.)</li>
                                        <li>Completed and signed Federal Partnership (1065) and/or Corporate Income Tax Returns (1120) including all schedules, statements and addenda for the last two years. (Required only if your ownership position is 25% or greater.)</li>
                                    </ul>
                                    </p>
                                    
                                    <p class="px-3">If you will use <span class="font-weight-bold">Alimony</span> or <span class="font-weight-bold">Child Support</span> to qualify:</p>
                                    <p class="ml-4 pt-0 px-3">
                                    <ul>
                                        <li>Provide divorce decree/court order stating amount, as well as, proof of receipt of funds for last year</li>
                                    </ul>
                                    </p>
                                    
                                    <p class="px-3">If you receive <span class="font-weight-bold">Social Security</span> income, <span class="font-weight-bold">Disability</span> or <span class="font-weight-bold">VA</span> benefits:</p>
                                    <p class="ml-4 pt-0 px-3">
                                    <ul>
                                        <li>Provide award letter from agency or organization</li>
                                    </ul>
                                    </p>
                                    
                                                                        
                                    <p class="px-3 font-weight-bold">Source of Funds and Down Payment</p>
                                    <p class="ml-4 pt-0 px-3">
                                    <ul>
                                        <li>Sale of your existing home - provide a copy of the signed sales contract on your current residence and statement or listing agreement if unsold (at closing, you must also provide a settlement/Closing Statement)</li>
                                        <li>Savings, checking or money market funds - provide copies of bank statements for the last 3 months</li>
                                        <li>Stocks and bonds - provide copies of your statement from your broker or copies of certificates</li>
                                        <li>Gifts - If part of your cash to close, provide Gift Affidavit and proof of receipt of funds</li>
                                        <li>Based on information appearing on your application and/or your credit report, you may be required to submit additional documentation</li>
                                    </ul>
                                    </p>
                                    
                                    <p class="px-3 font-weight-bold">Debt or Obligations</p>
                                    <p class="ml-4 pt-0 px-3">
                                    <ul>
                                        <li>Prepare a list of all names, addresses, account numbers, balances, and monthly payments for all current debts with copies of the last three monthly statements</li>
                                        <li>Include all names, addresses, account numbers, balances, and monthly payments for mortgage holders and/or landlords for the last two years</li>
                                        <li>If you are paying alimony or child support, include marital settlement/court order stating the terms of the obligation</li>
                                        <li>Check to cover Application Fee(s)</li>

                                    </ul>
                                    </p>
                                
                                </div>
                                
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapseSeven">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">How is my credit judged by lenders?</span>
                                    </a>
                                </div>
                                <div id="collapseSeven" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">Credit scoring is a system creditors use to help determine whether to give you credit. Information about you and your credit experiences, such as your bill-paying history, the number and type of accounts you have, late payments, collection actions, outstanding debt, and the age of your accounts, is collected from your credit application and your credit report. Using a statistical program, creditors compare this information to the credit performance of consumers with similar profiles. A credit scoring system awards points for each factor that helps predict who is most likely to repay a debt. A total number of points -- a credit score -- helps predict how creditworthy you are, that is, how likely it is that you will repay a loan and make the payments when due.</p>
                                    
                                    <p class="px-3">The most widely use credit scores are FICO scores, which were developed by Fair Isaac Company, Inc. Your score will fall between 350 (high risk) and 850 (low risk).</p>
                                    
                                    <p class="px-3">Because your credit report is an important part of many credit scoring systems, it is very important to make sure it's accurate before you submit a credit application. To get copies of your report, contact the three major credit reporting agencies:</p>
                                     
                                    <p class="px-3">Equifax: (800) 685-1111<br>
                                    Experian (formerly TRW): (888) EXPERIAN (397-3742)<br>
                                    Trans Union: (800) 916-8800<br>
                                    These agencies may charge you up to $9.00 for your credit report.</p>
                                    
                                    <p class="px-3">You are entitled to receive one free credit report every 12 months from each of the nationwide consumer credit reporting companies – Equifax, Experian and TransUnion. This free credit report may not contain your credit score and can be requested through the following website: https://www.annualcreditreport.com</p>
                                </div>
                                
                                
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapseEight">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">What can I do to improve my credit score?</span>
                                    </a>
                                </div>
                                <div id="collapseEight" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">Credit scoring models are complex and often vary among creditors and for different types of credit. If one factor changes, your score may change -- but improvement generally depends on how that factor relates to other factors considered by the model. Only the creditor can explain what might improve your score under the particular model used to evaluate your credit application.</p>
                                    
                                    <p class="px-3">Nevertheless, scoring models generally evaluate the following types of information in your credit report:
                                    </p>
                                    
                                    <p class="ml-4 pt-0 px-3">
                                    <ul>
                                        <li><span class="font-weight-bold">Have you paid your bills on time?</span> Payment history typically is a significant factor. It is likely that your score will be affected negatively if you have paid bills late, had an account referred to collections, or declared bankruptcy, if that history is reflected on your credit report.</li>
                                        <li class="pt-3"><span class="font-weight-bold">What is your outstanding debt?</span> Many scoring models evaluate the amount of debt you have compared to your credit limits. If the amount you owe is close to your credit limit, that is likely to have a negative effect on your score.</li>
                                        <li class="pt-3"><span class="font-weight-bold">How long is your credit history? </span> Generally, models consider the length of your credit track record. An insufficient credit history may have an effect on your score, but that can be offset by other factors, such as timely payments and low balances.</li>
                                        <li class="pt-3"><span class="font-weight-bold">Have you applied for new credit recently? </span> Many scoring models consider whether you have applied for credit recently by looking at "inquiries" on your credit report when you apply for credit. If you have applied for too many new accounts recently, that may negatively affect your score. However, not all inquiries are counted. Inquiries by creditors who are monitoring your account or looking at credit reports to make "prescreened" credit offers are not counted.</li>
                                        <li class="pt-3"><span class="font-weight-bold">How many and what types of credit accounts do you have?</span> Although it is generally good to have established credit accounts, too many credit card accounts may have a negative effect on your score. In addition, many models consider the type of credit accounts you have. For example, under some scoring models, loans from finance companies may negatively affect your credit score.</li>
                                    </ul>
                                    </p>

                                    <p class="px-3">Scoring models may be based on more than just information in your credit report. For example, the model may consider information from your credit application as well: your job or occupation, length of employment, or whether you own a home.</p>
                                    <p class="px-3">To improve your credit score under most models, concentrate on paying your bills on time, paying down outstanding balances, and not taking on new debt. It's likely to take some time to improve your score significantly.</p>
                                </div>
                                
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapseNine">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">What is an appraisal?</span>
                                    </a>
                                </div>
                                <div id="collapseNine" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">An Appraisal is an estimate of a property's fair market value. It's a document generally required (depending on the loan program) by a lender before loan approval to ensure that the mortgage loan amount is not more than the value of the property. The Appraisal is performed by an "Appraiser" typically a state-licensed professional who is trained to render expert opinions concerning property values, its location, amenities, and physical conditions.</p>
                                </div>
                                
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapseTen">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">What is PMI (Private Mortgage Insurance)?</span>
                                    </a>
                                </div>
                                <div id="collapseTen" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">On a conventional mortgage, when your down payment is less than 20% of the purchase price of the home mortgage lenders usually require you get Private Mortgage Insurance (PMI) to protect them in case you default on your mortgage. Sometimes you may need to pay up to 1-year's worth of PMI premiums at closing which can cost several hundred dollars. The best way to avoid this extra expense is to make a 20% down payment, or ask about other loan program options.</p>
                                </div>
                                
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapseEleven">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">What is 80-10-10 financing?</span>
                                    </a>
                                </div>
                                <div id="collapseEleven" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">Surprising as it may seem, some folks with hefty incomes find that it’s mighty tough for them to save enough money to make a 20% cash down payment on their dream homes. Using conventional financing, such buyers must purchase Private Mortgage Insurance (PMI) which increases the cost of home ownership and, ironically, makes it even more difficult to qualify for the mortgage. However, if you’re a dues-paying member of the cash-challenged class, don’t despair. Given that your income is sufficiently high, it’s eminently possible to avoid getting stuck with PMI. That is why 80-10-10 financing was invented. It is called 80-10-10 because a savings and loan association, bank, or other institutional lender provides a traditional 80% first mortgage, you get a 10% second mortgage, and make a cash down payment equal to 10% of the home’s purchase price. By using this method, you are no longer obligated to take out PMI on your property.</p>
                                    
                                    <p class="px-3">The same principle applies if you can only afford to make a 5% down, 80-15-5 financing is also available. However, because a smaller cash down payment increases the lender’s risk of default, do not be surprised when you are asked to pay higher loan fees and a higher mortgage interest rate for 80-15-5 than you pay for 80-10-10.</p>
                                </div>
                                
                                <div class="card-header collapsed my-1" data-toggle="collapse" href="#collapsetTweleve">
                                    <a class="card-title h5 text pr-2" style="cursor: pointer">
                                        <span class="font-weight-bold">What happens at closing ?</span>
                                    </a>
                                </div>
                                <div id="collapsetTweleve" class="card-body collapse" data-parent="#accordion" >
                                    <p class="px-3">The property is officially transferred from the seller to you at "Closing" or "Funding".</p>
                                    
                                    <p class="px-3">At closing, the ownership of the property is officially transferred from the seller to you. This may involve you, the seller, real estate agents, your attorney, the lender’s attorney, title or escrow firm representatives, clerks, secretaries, and other staff. You can have an attorney represent you if you can't attend the closing meeting, i.e., if you’re out-of-state. Closing can take anywhere from 1-hour to several depending on contingency clauses in the purchase offer, or any escrow accounts needing to be set up.</p>
                                    
                                    <p class="px-3">Most paperwork in closing or settlement is done by attorneys and real estate professionals. You may or may not be involved in some of the closing activities; it depends on who you are working with.</p>
                                    
                                    <p class="px-3">Prior to closing you should have a final inspection, or "walk-through" to insure requested repairs were performed, and items agreed to remain with the house are there such as drapes, lighting fixtures, etc.</p>
                                    
                                    <p class="px-3">In most states the settlement is completed by a title or escrow firm in which you forward all materials and information plus the appropriate cashier's checks so the firm can make the necessary disbursement. Your representative will deliver the check to the seller, and then give the keys to you.</p>
                                </div>
                                
                        </div>
                    </div>
                </div>
</section>
<?php include( 'assets/inc/footer.php' ); ?>
</body>

</html>